import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RejectTransitGatewayMulticastDomainAssociationsRequest, RejectTransitGatewayMulticastDomainAssociationsResult, } from "../models/models_5";
import { deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand, serializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand, } from "../protocols/Aws_ec2";
var RejectTransitGatewayMulticastDomainAssociationsCommand = (function (_super) {
    __extends(RejectTransitGatewayMulticastDomainAssociationsCommand, _super);
    function RejectTransitGatewayMulticastDomainAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RejectTransitGatewayMulticastDomainAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RejectTransitGatewayMulticastDomainAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RejectTransitGatewayMulticastDomainAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RejectTransitGatewayMulticastDomainAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RejectTransitGatewayMulticastDomainAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand(input, context);
    };
    RejectTransitGatewayMulticastDomainAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand(output, context);
    };
    return RejectTransitGatewayMulticastDomainAssociationsCommand;
}($Command));
export { RejectTransitGatewayMulticastDomainAssociationsCommand };
