import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PurchaseScheduledInstancesRequest, PurchaseScheduledInstancesResult } from "../models/models_5";
import { deserializeAws_ec2PurchaseScheduledInstancesCommand, serializeAws_ec2PurchaseScheduledInstancesCommand, } from "../protocols/Aws_ec2";
var PurchaseScheduledInstancesCommand = (function (_super) {
    __extends(PurchaseScheduledInstancesCommand, _super);
    function PurchaseScheduledInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PurchaseScheduledInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "PurchaseScheduledInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PurchaseScheduledInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PurchaseScheduledInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PurchaseScheduledInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2PurchaseScheduledInstancesCommand(input, context);
    };
    PurchaseScheduledInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2PurchaseScheduledInstancesCommand(output, context);
    };
    return PurchaseScheduledInstancesCommand;
}($Command));
export { PurchaseScheduledInstancesCommand };
