import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PurchaseHostReservationRequest, PurchaseHostReservationResult } from "../models/models_5";
import { deserializeAws_ec2PurchaseHostReservationCommand, serializeAws_ec2PurchaseHostReservationCommand, } from "../protocols/Aws_ec2";
var PurchaseHostReservationCommand = (function (_super) {
    __extends(PurchaseHostReservationCommand, _super);
    function PurchaseHostReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PurchaseHostReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "PurchaseHostReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PurchaseHostReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PurchaseHostReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PurchaseHostReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2PurchaseHostReservationCommand(input, context);
    };
    PurchaseHostReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2PurchaseHostReservationCommand(output, context);
    };
    return PurchaseHostReservationCommand;
}($Command));
export { PurchaseHostReservationCommand };
