import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ProvisionIpamPoolCidrRequest, ProvisionIpamPoolCidrResult } from "../models/models_5";
import { deserializeAws_ec2ProvisionIpamPoolCidrCommand, serializeAws_ec2ProvisionIpamPoolCidrCommand, } from "../protocols/Aws_ec2";
var ProvisionIpamPoolCidrCommand = (function (_super) {
    __extends(ProvisionIpamPoolCidrCommand, _super);
    function ProvisionIpamPoolCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ProvisionIpamPoolCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ProvisionIpamPoolCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ProvisionIpamPoolCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ProvisionIpamPoolCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ProvisionIpamPoolCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ProvisionIpamPoolCidrCommand(input, context);
    };
    ProvisionIpamPoolCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ProvisionIpamPoolCidrCommand(output, context);
    };
    return ProvisionIpamPoolCidrCommand;
}($Command));
export { ProvisionIpamPoolCidrCommand };
