import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ProvisionByoipCidrRequest, ProvisionByoipCidrResult } from "../models/models_5";
import { deserializeAws_ec2ProvisionByoipCidrCommand, serializeAws_ec2ProvisionByoipCidrCommand, } from "../protocols/Aws_ec2";
var ProvisionByoipCidrCommand = (function (_super) {
    __extends(ProvisionByoipCidrCommand, _super);
    function ProvisionByoipCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ProvisionByoipCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ProvisionByoipCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ProvisionByoipCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ProvisionByoipCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ProvisionByoipCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ProvisionByoipCidrCommand(input, context);
    };
    ProvisionByoipCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ProvisionByoipCidrCommand(output, context);
    };
    return ProvisionByoipCidrCommand;
}($Command));
export { ProvisionByoipCidrCommand };
