import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { MoveByoipCidrToIpamRequest, MoveByoipCidrToIpamResult } from "../models/models_5";
import { deserializeAws_ec2MoveByoipCidrToIpamCommand, serializeAws_ec2MoveByoipCidrToIpamCommand, } from "../protocols/Aws_ec2";
var MoveByoipCidrToIpamCommand = (function (_super) {
    __extends(MoveByoipCidrToIpamCommand, _super);
    function MoveByoipCidrToIpamCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    MoveByoipCidrToIpamCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "MoveByoipCidrToIpamCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: MoveByoipCidrToIpamRequest.filterSensitiveLog,
            outputFilterSensitiveLog: MoveByoipCidrToIpamResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    MoveByoipCidrToIpamCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2MoveByoipCidrToIpamCommand(input, context);
    };
    MoveByoipCidrToIpamCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2MoveByoipCidrToIpamCommand(output, context);
    };
    return MoveByoipCidrToIpamCommand;
}($Command));
export { MoveByoipCidrToIpamCommand };
