import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpnTunnelCertificateRequest, ModifyVpnTunnelCertificateResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpnTunnelCertificateCommand, serializeAws_ec2ModifyVpnTunnelCertificateCommand, } from "../protocols/Aws_ec2";
var ModifyVpnTunnelCertificateCommand = (function (_super) {
    __extends(ModifyVpnTunnelCertificateCommand, _super);
    function ModifyVpnTunnelCertificateCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpnTunnelCertificateCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpnTunnelCertificateCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpnTunnelCertificateRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpnTunnelCertificateResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpnTunnelCertificateCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpnTunnelCertificateCommand(input, context);
    };
    ModifyVpnTunnelCertificateCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpnTunnelCertificateCommand(output, context);
    };
    return ModifyVpnTunnelCertificateCommand;
}($Command));
export { ModifyVpnTunnelCertificateCommand };
