import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcPeeringConnectionOptionsRequest, ModifyVpcPeeringConnectionOptionsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand, serializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand, } from "../protocols/Aws_ec2";
var ModifyVpcPeeringConnectionOptionsCommand = (function (_super) {
    __extends(ModifyVpcPeeringConnectionOptionsCommand, _super);
    function ModifyVpcPeeringConnectionOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcPeeringConnectionOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcPeeringConnectionOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcPeeringConnectionOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcPeeringConnectionOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcPeeringConnectionOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand(input, context);
    };
    ModifyVpcPeeringConnectionOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand(output, context);
    };
    return ModifyVpcPeeringConnectionOptionsCommand;
}($Command));
export { ModifyVpcPeeringConnectionOptionsCommand };
