import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcEndpointRequest, ModifyVpcEndpointResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcEndpointCommand, serializeAws_ec2ModifyVpcEndpointCommand, } from "../protocols/Aws_ec2";
var ModifyVpcEndpointCommand = (function (_super) {
    __extends(ModifyVpcEndpointCommand, _super);
    function ModifyVpcEndpointCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcEndpointCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcEndpointCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcEndpointRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcEndpointResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcEndpointCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcEndpointCommand(input, context);
    };
    ModifyVpcEndpointCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcEndpointCommand(output, context);
    };
    return ModifyVpcEndpointCommand;
}($Command));
export { ModifyVpcEndpointCommand };
