import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVolumeRequest, ModifyVolumeResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVolumeCommand, serializeAws_ec2ModifyVolumeCommand } from "../protocols/Aws_ec2";
var ModifyVolumeCommand = (function (_super) {
    __extends(ModifyVolumeCommand, _super);
    function ModifyVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVolumeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVolumeCommand(input, context);
    };
    ModifyVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVolumeCommand(output, context);
    };
    return ModifyVolumeCommand;
}($Command));
export { ModifyVolumeCommand };
