import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVolumeAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyVolumeAttributeCommand, serializeAws_ec2ModifyVolumeAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyVolumeAttributeCommand = (function (_super) {
    __extends(ModifyVolumeAttributeCommand, _super);
    function ModifyVolumeAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVolumeAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVolumeAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVolumeAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVolumeAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVolumeAttributeCommand(input, context);
    };
    ModifyVolumeAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVolumeAttributeCommand(output, context);
    };
    return ModifyVolumeAttributeCommand;
}($Command));
export { ModifyVolumeAttributeCommand };
