import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyTrafficMirrorFilterRuleRequest, ModifyTrafficMirrorFilterRuleResult } from "../models/models_5";
import { deserializeAws_ec2ModifyTrafficMirrorFilterRuleCommand, serializeAws_ec2ModifyTrafficMirrorFilterRuleCommand, } from "../protocols/Aws_ec2";
var ModifyTrafficMirrorFilterRuleCommand = (function (_super) {
    __extends(ModifyTrafficMirrorFilterRuleCommand, _super);
    function ModifyTrafficMirrorFilterRuleCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyTrafficMirrorFilterRuleCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyTrafficMirrorFilterRuleCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyTrafficMirrorFilterRuleRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyTrafficMirrorFilterRuleResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyTrafficMirrorFilterRuleCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyTrafficMirrorFilterRuleCommand(input, context);
    };
    ModifyTrafficMirrorFilterRuleCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyTrafficMirrorFilterRuleCommand(output, context);
    };
    return ModifyTrafficMirrorFilterRuleCommand;
}($Command));
export { ModifyTrafficMirrorFilterRuleCommand };
