import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifySubnetAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifySubnetAttributeCommand, serializeAws_ec2ModifySubnetAttributeCommand, } from "../protocols/Aws_ec2";
var ModifySubnetAttributeCommand = (function (_super) {
    __extends(ModifySubnetAttributeCommand, _super);
    function ModifySubnetAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifySubnetAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifySubnetAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifySubnetAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifySubnetAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifySubnetAttributeCommand(input, context);
    };
    ModifySubnetAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifySubnetAttributeCommand(output, context);
    };
    return ModifySubnetAttributeCommand;
}($Command));
export { ModifySubnetAttributeCommand };
