import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifySpotFleetRequestRequest, ModifySpotFleetRequestResponse } from "../models/models_5";
import { deserializeAws_ec2ModifySpotFleetRequestCommand, serializeAws_ec2ModifySpotFleetRequestCommand, } from "../protocols/Aws_ec2";
var ModifySpotFleetRequestCommand = (function (_super) {
    __extends(ModifySpotFleetRequestCommand, _super);
    function ModifySpotFleetRequestCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifySpotFleetRequestCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifySpotFleetRequestCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifySpotFleetRequestRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifySpotFleetRequestResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifySpotFleetRequestCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifySpotFleetRequestCommand(input, context);
    };
    ModifySpotFleetRequestCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifySpotFleetRequestCommand(output, context);
    };
    return ModifySpotFleetRequestCommand;
}($Command));
export { ModifySpotFleetRequestCommand };
