import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifySecurityGroupRulesRequest, ModifySecurityGroupRulesResult } from "../models/models_5";
import { deserializeAws_ec2ModifySecurityGroupRulesCommand, serializeAws_ec2ModifySecurityGroupRulesCommand, } from "../protocols/Aws_ec2";
var ModifySecurityGroupRulesCommand = (function (_super) {
    __extends(ModifySecurityGroupRulesCommand, _super);
    function ModifySecurityGroupRulesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifySecurityGroupRulesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifySecurityGroupRulesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifySecurityGroupRulesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifySecurityGroupRulesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifySecurityGroupRulesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifySecurityGroupRulesCommand(input, context);
    };
    ModifySecurityGroupRulesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifySecurityGroupRulesCommand(output, context);
    };
    return ModifySecurityGroupRulesCommand;
}($Command));
export { ModifySecurityGroupRulesCommand };
