import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIpamResourceCidrRequest, ModifyIpamResourceCidrResult } from "../models/models_5";
import { deserializeAws_ec2ModifyIpamResourceCidrCommand, serializeAws_ec2ModifyIpamResourceCidrCommand, } from "../protocols/Aws_ec2";
var ModifyIpamResourceCidrCommand = (function (_super) {
    __extends(ModifyIpamResourceCidrCommand, _super);
    function ModifyIpamResourceCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIpamResourceCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIpamResourceCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIpamResourceCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyIpamResourceCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIpamResourceCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIpamResourceCidrCommand(input, context);
    };
    ModifyIpamResourceCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIpamResourceCidrCommand(output, context);
    };
    return ModifyIpamResourceCidrCommand;
}($Command));
export { ModifyIpamResourceCidrCommand };
