import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIpamPoolRequest, ModifyIpamPoolResult } from "../models/models_5";
import { deserializeAws_ec2ModifyIpamPoolCommand, serializeAws_ec2ModifyIpamPoolCommand } from "../protocols/Aws_ec2";
var ModifyIpamPoolCommand = (function (_super) {
    __extends(ModifyIpamPoolCommand, _super);
    function ModifyIpamPoolCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIpamPoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIpamPoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIpamPoolRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyIpamPoolResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIpamPoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIpamPoolCommand(input, context);
    };
    ModifyIpamPoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIpamPoolCommand(output, context);
    };
    return ModifyIpamPoolCommand;
}($Command));
export { ModifyIpamPoolCommand };
