import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIpamRequest, ModifyIpamResult } from "../models/models_5";
import { deserializeAws_ec2ModifyIpamCommand, serializeAws_ec2ModifyIpamCommand } from "../protocols/Aws_ec2";
var ModifyIpamCommand = (function (_super) {
    __extends(ModifyIpamCommand, _super);
    function ModifyIpamCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIpamCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIpamCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIpamRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyIpamResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIpamCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIpamCommand(input, context);
    };
    ModifyIpamCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIpamCommand(output, context);
    };
    return ModifyIpamCommand;
}($Command));
export { ModifyIpamCommand };
