import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstancePlacementRequest, ModifyInstancePlacementResult } from "../models/models_5";
import { deserializeAws_ec2ModifyInstancePlacementCommand, serializeAws_ec2ModifyInstancePlacementCommand, } from "../protocols/Aws_ec2";
var ModifyInstancePlacementCommand = (function (_super) {
    __extends(ModifyInstancePlacementCommand, _super);
    function ModifyInstancePlacementCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstancePlacementCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstancePlacementCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstancePlacementRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstancePlacementResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstancePlacementCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstancePlacementCommand(input, context);
    };
    ModifyInstancePlacementCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstancePlacementCommand(output, context);
    };
    return ModifyInstancePlacementCommand;
}($Command));
export { ModifyInstancePlacementCommand };
