import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceCreditSpecificationRequest, ModifyInstanceCreditSpecificationResult } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceCreditSpecificationCommand, serializeAws_ec2ModifyInstanceCreditSpecificationCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceCreditSpecificationCommand = (function (_super) {
    __extends(ModifyInstanceCreditSpecificationCommand, _super);
    function ModifyInstanceCreditSpecificationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceCreditSpecificationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceCreditSpecificationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceCreditSpecificationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstanceCreditSpecificationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceCreditSpecificationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceCreditSpecificationCommand(input, context);
    };
    ModifyInstanceCreditSpecificationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceCreditSpecificationCommand(output, context);
    };
    return ModifyInstanceCreditSpecificationCommand;
}($Command));
export { ModifyInstanceCreditSpecificationCommand };
