import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceCapacityReservationAttributesRequest, ModifyInstanceCapacityReservationAttributesResult, } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand, serializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceCapacityReservationAttributesCommand = (function (_super) {
    __extends(ModifyInstanceCapacityReservationAttributesCommand, _super);
    function ModifyInstanceCapacityReservationAttributesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceCapacityReservationAttributesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceCapacityReservationAttributesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceCapacityReservationAttributesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstanceCapacityReservationAttributesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceCapacityReservationAttributesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand(input, context);
    };
    ModifyInstanceCapacityReservationAttributesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand(output, context);
    };
    return ModifyInstanceCapacityReservationAttributesCommand;
}($Command));
export { ModifyInstanceCapacityReservationAttributesCommand };
