import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIdFormatRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyIdFormatCommand, serializeAws_ec2ModifyIdFormatCommand } from "../protocols/Aws_ec2";
var ModifyIdFormatCommand = (function (_super) {
    __extends(ModifyIdFormatCommand, _super);
    function ModifyIdFormatCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIdFormatCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIdFormatCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIdFormatRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIdFormatCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIdFormatCommand(input, context);
    };
    ModifyIdFormatCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIdFormatCommand(output, context);
    };
    return ModifyIdFormatCommand;
}($Command));
export { ModifyIdFormatCommand };
