import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyEbsDefaultKmsKeyIdRequest, ModifyEbsDefaultKmsKeyIdResult } from "../models/models_5";
import { deserializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand, serializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand, } from "../protocols/Aws_ec2";
var ModifyEbsDefaultKmsKeyIdCommand = (function (_super) {
    __extends(ModifyEbsDefaultKmsKeyIdCommand, _super);
    function ModifyEbsDefaultKmsKeyIdCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyEbsDefaultKmsKeyIdCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyEbsDefaultKmsKeyIdCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyEbsDefaultKmsKeyIdRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyEbsDefaultKmsKeyIdResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyEbsDefaultKmsKeyIdCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand(input, context);
    };
    ModifyEbsDefaultKmsKeyIdCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand(output, context);
    };
    return ModifyEbsDefaultKmsKeyIdCommand;
}($Command));
export { ModifyEbsDefaultKmsKeyIdCommand };
