import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportSnapshotRequest, ImportSnapshotResult } from "../models/models_5";
import { deserializeAws_ec2ImportSnapshotCommand, serializeAws_ec2ImportSnapshotCommand } from "../protocols/Aws_ec2";
var ImportSnapshotCommand = (function (_super) {
    __extends(ImportSnapshotCommand, _super);
    function ImportSnapshotCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportSnapshotCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportSnapshotCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportSnapshotRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportSnapshotResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportSnapshotCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportSnapshotCommand(input, context);
    };
    ImportSnapshotCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportSnapshotCommand(output, context);
    };
    return ImportSnapshotCommand;
}($Command));
export { ImportSnapshotCommand };
