import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportImageRequest, ImportImageResult } from "../models/models_5";
import { deserializeAws_ec2ImportImageCommand, serializeAws_ec2ImportImageCommand } from "../protocols/Aws_ec2";
var ImportImageCommand = (function (_super) {
    __extends(ImportImageCommand, _super);
    function ImportImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportImageCommand(input, context);
    };
    ImportImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportImageCommand(output, context);
    };
    return ImportImageCommand;
}($Command));
export { ImportImageCommand };
