import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetVpnConnectionDeviceTypesRequest, GetVpnConnectionDeviceTypesResult } from "../models/models_5";
import { deserializeAws_ec2GetVpnConnectionDeviceTypesCommand, serializeAws_ec2GetVpnConnectionDeviceTypesCommand, } from "../protocols/Aws_ec2";
var GetVpnConnectionDeviceTypesCommand = (function (_super) {
    __extends(GetVpnConnectionDeviceTypesCommand, _super);
    function GetVpnConnectionDeviceTypesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetVpnConnectionDeviceTypesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetVpnConnectionDeviceTypesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetVpnConnectionDeviceTypesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetVpnConnectionDeviceTypesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetVpnConnectionDeviceTypesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetVpnConnectionDeviceTypesCommand(input, context);
    };
    GetVpnConnectionDeviceTypesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetVpnConnectionDeviceTypesCommand(output, context);
    };
    return GetVpnConnectionDeviceTypesCommand;
}($Command));
export { GetVpnConnectionDeviceTypesCommand };
