import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetTransitGatewayRouteTableAssociationsRequest, GetTransitGatewayRouteTableAssociationsResult, } from "../models/models_5";
import { deserializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand, serializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand, } from "../protocols/Aws_ec2";
var GetTransitGatewayRouteTableAssociationsCommand = (function (_super) {
    __extends(GetTransitGatewayRouteTableAssociationsCommand, _super);
    function GetTransitGatewayRouteTableAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetTransitGatewayRouteTableAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetTransitGatewayRouteTableAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetTransitGatewayRouteTableAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetTransitGatewayRouteTableAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetTransitGatewayRouteTableAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand(input, context);
    };
    GetTransitGatewayRouteTableAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand(output, context);
    };
    return GetTransitGatewayRouteTableAssociationsCommand;
}($Command));
export { GetTransitGatewayRouteTableAssociationsCommand };
