import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetTransitGatewayMulticastDomainAssociationsRequest, GetTransitGatewayMulticastDomainAssociationsResult, } from "../models/models_5";
import { deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand, serializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand, } from "../protocols/Aws_ec2";
var GetTransitGatewayMulticastDomainAssociationsCommand = (function (_super) {
    __extends(GetTransitGatewayMulticastDomainAssociationsCommand, _super);
    function GetTransitGatewayMulticastDomainAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetTransitGatewayMulticastDomainAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetTransitGatewayMulticastDomainAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetTransitGatewayMulticastDomainAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetTransitGatewayMulticastDomainAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetTransitGatewayMulticastDomainAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand(input, context);
    };
    GetTransitGatewayMulticastDomainAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand(output, context);
    };
    return GetTransitGatewayMulticastDomainAssociationsCommand;
}($Command));
export { GetTransitGatewayMulticastDomainAssociationsCommand };
