import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetTransitGatewayAttachmentPropagationsRequest, GetTransitGatewayAttachmentPropagationsResult, } from "../models/models_5";
import { deserializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand, serializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand, } from "../protocols/Aws_ec2";
var GetTransitGatewayAttachmentPropagationsCommand = (function (_super) {
    __extends(GetTransitGatewayAttachmentPropagationsCommand, _super);
    function GetTransitGatewayAttachmentPropagationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetTransitGatewayAttachmentPropagationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetTransitGatewayAttachmentPropagationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetTransitGatewayAttachmentPropagationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetTransitGatewayAttachmentPropagationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetTransitGatewayAttachmentPropagationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand(input, context);
    };
    GetTransitGatewayAttachmentPropagationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand(output, context);
    };
    return GetTransitGatewayAttachmentPropagationsCommand;
}($Command));
export { GetTransitGatewayAttachmentPropagationsCommand };
