import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetManagedPrefixListAssociationsRequest, GetManagedPrefixListAssociationsResult } from "../models/models_5";
import { deserializeAws_ec2GetManagedPrefixListAssociationsCommand, serializeAws_ec2GetManagedPrefixListAssociationsCommand, } from "../protocols/Aws_ec2";
var GetManagedPrefixListAssociationsCommand = (function (_super) {
    __extends(GetManagedPrefixListAssociationsCommand, _super);
    function GetManagedPrefixListAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetManagedPrefixListAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetManagedPrefixListAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetManagedPrefixListAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetManagedPrefixListAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetManagedPrefixListAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetManagedPrefixListAssociationsCommand(input, context);
    };
    GetManagedPrefixListAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetManagedPrefixListAssociationsCommand(output, context);
    };
    return GetManagedPrefixListAssociationsCommand;
}($Command));
export { GetManagedPrefixListAssociationsCommand };
