import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetIpamAddressHistoryRequest, GetIpamAddressHistoryResult } from "../models/models_4";
import { deserializeAws_ec2GetIpamAddressHistoryCommand, serializeAws_ec2GetIpamAddressHistoryCommand, } from "../protocols/Aws_ec2";
var GetIpamAddressHistoryCommand = (function (_super) {
    __extends(GetIpamAddressHistoryCommand, _super);
    function GetIpamAddressHistoryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetIpamAddressHistoryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetIpamAddressHistoryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetIpamAddressHistoryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetIpamAddressHistoryResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetIpamAddressHistoryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetIpamAddressHistoryCommand(input, context);
    };
    GetIpamAddressHistoryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetIpamAddressHistoryCommand(output, context);
    };
    return GetIpamAddressHistoryCommand;
}($Command));
export { GetIpamAddressHistoryCommand };
