import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetInstanceTypesFromInstanceRequirementsRequest, GetInstanceTypesFromInstanceRequirementsResult, } from "../models/models_4";
import { deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand, serializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand, } from "../protocols/Aws_ec2";
var GetInstanceTypesFromInstanceRequirementsCommand = (function (_super) {
    __extends(GetInstanceTypesFromInstanceRequirementsCommand, _super);
    function GetInstanceTypesFromInstanceRequirementsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetInstanceTypesFromInstanceRequirementsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetInstanceTypesFromInstanceRequirementsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetInstanceTypesFromInstanceRequirementsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetInstanceTypesFromInstanceRequirementsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetInstanceTypesFromInstanceRequirementsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand(input, context);
    };
    GetInstanceTypesFromInstanceRequirementsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand(output, context);
    };
    return GetInstanceTypesFromInstanceRequirementsCommand;
}($Command));
export { GetInstanceTypesFromInstanceRequirementsCommand };
