import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetHostReservationPurchasePreviewRequest, GetHostReservationPurchasePreviewResult } from "../models/models_4";
import { deserializeAws_ec2GetHostReservationPurchasePreviewCommand, serializeAws_ec2GetHostReservationPurchasePreviewCommand, } from "../protocols/Aws_ec2";
var GetHostReservationPurchasePreviewCommand = (function (_super) {
    __extends(GetHostReservationPurchasePreviewCommand, _super);
    function GetHostReservationPurchasePreviewCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetHostReservationPurchasePreviewCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetHostReservationPurchasePreviewCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetHostReservationPurchasePreviewRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetHostReservationPurchasePreviewResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetHostReservationPurchasePreviewCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetHostReservationPurchasePreviewCommand(input, context);
    };
    GetHostReservationPurchasePreviewCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetHostReservationPurchasePreviewCommand(output, context);
    };
    return GetHostReservationPurchasePreviewCommand;
}($Command));
export { GetHostReservationPurchasePreviewCommand };
