import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetFlowLogsIntegrationTemplateRequest, GetFlowLogsIntegrationTemplateResult } from "../models/models_4";
import { deserializeAws_ec2GetFlowLogsIntegrationTemplateCommand, serializeAws_ec2GetFlowLogsIntegrationTemplateCommand, } from "../protocols/Aws_ec2";
var GetFlowLogsIntegrationTemplateCommand = (function (_super) {
    __extends(GetFlowLogsIntegrationTemplateCommand, _super);
    function GetFlowLogsIntegrationTemplateCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetFlowLogsIntegrationTemplateCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetFlowLogsIntegrationTemplateCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetFlowLogsIntegrationTemplateRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetFlowLogsIntegrationTemplateResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetFlowLogsIntegrationTemplateCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetFlowLogsIntegrationTemplateCommand(input, context);
    };
    GetFlowLogsIntegrationTemplateCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetFlowLogsIntegrationTemplateCommand(output, context);
    };
    return GetFlowLogsIntegrationTemplateCommand;
}($Command));
export { GetFlowLogsIntegrationTemplateCommand };
