import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetConsoleScreenshotRequest, GetConsoleScreenshotResult } from "../models/models_4";
import { deserializeAws_ec2GetConsoleScreenshotCommand, serializeAws_ec2GetConsoleScreenshotCommand, } from "../protocols/Aws_ec2";
var GetConsoleScreenshotCommand = (function (_super) {
    __extends(GetConsoleScreenshotCommand, _super);
    function GetConsoleScreenshotCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetConsoleScreenshotCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetConsoleScreenshotCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetConsoleScreenshotRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetConsoleScreenshotResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetConsoleScreenshotCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetConsoleScreenshotCommand(input, context);
    };
    GetConsoleScreenshotCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetConsoleScreenshotCommand(output, context);
    };
    return GetConsoleScreenshotCommand;
}($Command));
export { GetConsoleScreenshotCommand };
