import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetConsoleOutputRequest, GetConsoleOutputResult } from "../models/models_4";
import { deserializeAws_ec2GetConsoleOutputCommand, serializeAws_ec2GetConsoleOutputCommand, } from "../protocols/Aws_ec2";
var GetConsoleOutputCommand = (function (_super) {
    __extends(GetConsoleOutputCommand, _super);
    function GetConsoleOutputCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetConsoleOutputCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetConsoleOutputCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetConsoleOutputRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetConsoleOutputResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetConsoleOutputCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetConsoleOutputCommand(input, context);
    };
    GetConsoleOutputCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetConsoleOutputCommand(output, context);
    };
    return GetConsoleOutputCommand;
}($Command));
export { GetConsoleOutputCommand };
