import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ExportTransitGatewayRoutesRequest, ExportTransitGatewayRoutesResult } from "../models/models_4";
import { deserializeAws_ec2ExportTransitGatewayRoutesCommand, serializeAws_ec2ExportTransitGatewayRoutesCommand, } from "../protocols/Aws_ec2";
var ExportTransitGatewayRoutesCommand = (function (_super) {
    __extends(ExportTransitGatewayRoutesCommand, _super);
    function ExportTransitGatewayRoutesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ExportTransitGatewayRoutesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ExportTransitGatewayRoutesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ExportTransitGatewayRoutesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ExportTransitGatewayRoutesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ExportTransitGatewayRoutesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ExportTransitGatewayRoutesCommand(input, context);
    };
    ExportTransitGatewayRoutesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ExportTransitGatewayRoutesCommand(output, context);
    };
    return ExportTransitGatewayRoutesCommand;
}($Command));
export { ExportTransitGatewayRoutesCommand };
