import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ExportClientVpnClientConfigurationRequest, ExportClientVpnClientConfigurationResult, } from "../models/models_4";
import { deserializeAws_ec2ExportClientVpnClientConfigurationCommand, serializeAws_ec2ExportClientVpnClientConfigurationCommand, } from "../protocols/Aws_ec2";
var ExportClientVpnClientConfigurationCommand = (function (_super) {
    __extends(ExportClientVpnClientConfigurationCommand, _super);
    function ExportClientVpnClientConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ExportClientVpnClientConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ExportClientVpnClientConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ExportClientVpnClientConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ExportClientVpnClientConfigurationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ExportClientVpnClientConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ExportClientVpnClientConfigurationCommand(input, context);
    };
    ExportClientVpnClientConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ExportClientVpnClientConfigurationCommand(output, context);
    };
    return ExportClientVpnClientConfigurationCommand;
}($Command));
export { ExportClientVpnClientConfigurationCommand };
