import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateVpcCidrBlockRequest, DisassociateVpcCidrBlockResult } from "../models/models_4";
import { deserializeAws_ec2DisassociateVpcCidrBlockCommand, serializeAws_ec2DisassociateVpcCidrBlockCommand, } from "../protocols/Aws_ec2";
var DisassociateVpcCidrBlockCommand = (function (_super) {
    __extends(DisassociateVpcCidrBlockCommand, _super);
    function DisassociateVpcCidrBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateVpcCidrBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateVpcCidrBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateVpcCidrBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateVpcCidrBlockResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateVpcCidrBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateVpcCidrBlockCommand(input, context);
    };
    DisassociateVpcCidrBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateVpcCidrBlockCommand(output, context);
    };
    return DisassociateVpcCidrBlockCommand;
}($Command));
export { DisassociateVpcCidrBlockCommand };
