import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateTrunkInterfaceRequest, DisassociateTrunkInterfaceResult } from "../models/models_4";
import { deserializeAws_ec2DisassociateTrunkInterfaceCommand, serializeAws_ec2DisassociateTrunkInterfaceCommand, } from "../protocols/Aws_ec2";
var DisassociateTrunkInterfaceCommand = (function (_super) {
    __extends(DisassociateTrunkInterfaceCommand, _super);
    function DisassociateTrunkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateTrunkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateTrunkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateTrunkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateTrunkInterfaceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateTrunkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateTrunkInterfaceCommand(input, context);
    };
    DisassociateTrunkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateTrunkInterfaceCommand(output, context);
    };
    return DisassociateTrunkInterfaceCommand;
}($Command));
export { DisassociateTrunkInterfaceCommand };
