import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateTransitGatewayMulticastDomainRequest, DisassociateTransitGatewayMulticastDomainResult, } from "../models/models_4";
import { deserializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand, serializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand, } from "../protocols/Aws_ec2";
var DisassociateTransitGatewayMulticastDomainCommand = (function (_super) {
    __extends(DisassociateTransitGatewayMulticastDomainCommand, _super);
    function DisassociateTransitGatewayMulticastDomainCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateTransitGatewayMulticastDomainCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateTransitGatewayMulticastDomainCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateTransitGatewayMulticastDomainRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateTransitGatewayMulticastDomainResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateTransitGatewayMulticastDomainCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand(input, context);
    };
    DisassociateTransitGatewayMulticastDomainCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand(output, context);
    };
    return DisassociateTransitGatewayMulticastDomainCommand;
}($Command));
export { DisassociateTransitGatewayMulticastDomainCommand };
