import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateEnclaveCertificateIamRoleRequest, DisassociateEnclaveCertificateIamRoleResult, } from "../models/models_4";
import { deserializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand, serializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand, } from "../protocols/Aws_ec2";
var DisassociateEnclaveCertificateIamRoleCommand = (function (_super) {
    __extends(DisassociateEnclaveCertificateIamRoleCommand, _super);
    function DisassociateEnclaveCertificateIamRoleCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateEnclaveCertificateIamRoleCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateEnclaveCertificateIamRoleCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateEnclaveCertificateIamRoleRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateEnclaveCertificateIamRoleResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateEnclaveCertificateIamRoleCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand(input, context);
    };
    DisassociateEnclaveCertificateIamRoleCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand(output, context);
    };
    return DisassociateEnclaveCertificateIamRoleCommand;
}($Command));
export { DisassociateEnclaveCertificateIamRoleCommand };
