import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateClientVpnTargetNetworkRequest, DisassociateClientVpnTargetNetworkResult, } from "../models/models_4";
import { deserializeAws_ec2DisassociateClientVpnTargetNetworkCommand, serializeAws_ec2DisassociateClientVpnTargetNetworkCommand, } from "../protocols/Aws_ec2";
var DisassociateClientVpnTargetNetworkCommand = (function (_super) {
    __extends(DisassociateClientVpnTargetNetworkCommand, _super);
    function DisassociateClientVpnTargetNetworkCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateClientVpnTargetNetworkCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateClientVpnTargetNetworkCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateClientVpnTargetNetworkRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateClientVpnTargetNetworkResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateClientVpnTargetNetworkCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateClientVpnTargetNetworkCommand(input, context);
    };
    DisassociateClientVpnTargetNetworkCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateClientVpnTargetNetworkCommand(output, context);
    };
    return DisassociateClientVpnTargetNetworkCommand;
}($Command));
export { DisassociateClientVpnTargetNetworkCommand };
