import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateAddressRequest } from "../models/models_4";
import { deserializeAws_ec2DisassociateAddressCommand, serializeAws_ec2DisassociateAddressCommand, } from "../protocols/Aws_ec2";
var DisassociateAddressCommand = (function (_super) {
    __extends(DisassociateAddressCommand, _super);
    function DisassociateAddressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateAddressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateAddressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateAddressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateAddressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateAddressCommand(input, context);
    };
    DisassociateAddressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateAddressCommand(output, context);
    };
    return DisassociateAddressCommand;
}($Command));
export { DisassociateAddressCommand };
