import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableVpcClassicLinkRequest, DisableVpcClassicLinkResult } from "../models/models_4";
import { deserializeAws_ec2DisableVpcClassicLinkCommand, serializeAws_ec2DisableVpcClassicLinkCommand, } from "../protocols/Aws_ec2";
var DisableVpcClassicLinkCommand = (function (_super) {
    __extends(DisableVpcClassicLinkCommand, _super);
    function DisableVpcClassicLinkCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableVpcClassicLinkCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableVpcClassicLinkCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableVpcClassicLinkRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableVpcClassicLinkResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableVpcClassicLinkCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableVpcClassicLinkCommand(input, context);
    };
    DisableVpcClassicLinkCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableVpcClassicLinkCommand(output, context);
    };
    return DisableVpcClassicLinkCommand;
}($Command));
export { DisableVpcClassicLinkCommand };
