import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableVgwRoutePropagationRequest } from "../models/models_4";
import { deserializeAws_ec2DisableVgwRoutePropagationCommand, serializeAws_ec2DisableVgwRoutePropagationCommand, } from "../protocols/Aws_ec2";
var DisableVgwRoutePropagationCommand = (function (_super) {
    __extends(DisableVgwRoutePropagationCommand, _super);
    function DisableVgwRoutePropagationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableVgwRoutePropagationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableVgwRoutePropagationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableVgwRoutePropagationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableVgwRoutePropagationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableVgwRoutePropagationCommand(input, context);
    };
    DisableVgwRoutePropagationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableVgwRoutePropagationCommand(output, context);
    };
    return DisableVgwRoutePropagationCommand;
}($Command));
export { DisableVgwRoutePropagationCommand };
