import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableSerialConsoleAccessRequest, DisableSerialConsoleAccessResult } from "../models/models_4";
import { deserializeAws_ec2DisableSerialConsoleAccessCommand, serializeAws_ec2DisableSerialConsoleAccessCommand, } from "../protocols/Aws_ec2";
var DisableSerialConsoleAccessCommand = (function (_super) {
    __extends(DisableSerialConsoleAccessCommand, _super);
    function DisableSerialConsoleAccessCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableSerialConsoleAccessCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableSerialConsoleAccessCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableSerialConsoleAccessRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableSerialConsoleAccessResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableSerialConsoleAccessCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableSerialConsoleAccessCommand(input, context);
    };
    DisableSerialConsoleAccessCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableSerialConsoleAccessCommand(output, context);
    };
    return DisableSerialConsoleAccessCommand;
}($Command));
export { DisableSerialConsoleAccessCommand };
