import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableImageDeprecationRequest, DisableImageDeprecationResult } from "../models/models_4";
import { deserializeAws_ec2DisableImageDeprecationCommand, serializeAws_ec2DisableImageDeprecationCommand, } from "../protocols/Aws_ec2";
var DisableImageDeprecationCommand = (function (_super) {
    __extends(DisableImageDeprecationCommand, _super);
    function DisableImageDeprecationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableImageDeprecationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableImageDeprecationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableImageDeprecationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableImageDeprecationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableImageDeprecationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableImageDeprecationCommand(input, context);
    };
    DisableImageDeprecationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableImageDeprecationCommand(output, context);
    };
    return DisableImageDeprecationCommand;
}($Command));
export { DisableImageDeprecationCommand };
