import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableFastSnapshotRestoresRequest, DisableFastSnapshotRestoresResult } from "../models/models_4";
import { deserializeAws_ec2DisableFastSnapshotRestoresCommand, serializeAws_ec2DisableFastSnapshotRestoresCommand, } from "../protocols/Aws_ec2";
var DisableFastSnapshotRestoresCommand = (function (_super) {
    __extends(DisableFastSnapshotRestoresCommand, _super);
    function DisableFastSnapshotRestoresCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableFastSnapshotRestoresCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableFastSnapshotRestoresCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableFastSnapshotRestoresRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableFastSnapshotRestoresResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableFastSnapshotRestoresCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableFastSnapshotRestoresCommand(input, context);
    };
    DisableFastSnapshotRestoresCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableFastSnapshotRestoresCommand(output, context);
    };
    return DisableFastSnapshotRestoresCommand;
}($Command));
export { DisableFastSnapshotRestoresCommand };
