import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointServicesCommand, serializeAws_ec2DescribeVpcEndpointServicesCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointServicesCommand = (function (_super) {
    __extends(DescribeVpcEndpointServicesCommand, _super);
    function DescribeVpcEndpointServicesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointServicesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointServicesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointServicesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointServicesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointServicesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointServicesCommand(input, context);
    };
    DescribeVpcEndpointServicesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointServicesCommand(output, context);
    };
    return DescribeVpcEndpointServicesCommand;
}($Command));
export { DescribeVpcEndpointServicesCommand };
